<?php 
/**
* Extension of the Codeigniter string helper.
*
* @package direct-project-innovation-initiative
* @subpackage helpers
*/

load_libraries('Error_helper', 'Validator');

/**
* Returns true if the first string is a substring of the second string.
* @param string
* @param string
* @return boolean
*/
if(!function_exists('string_contains')){
	function string_contains($needle, $haystack){		
		if(!validates_as('string', $needle)) return should_be('a string', $needle);
		if(!validates_as('string', $haystack)) return should_be('a string', $haystack);		
		
		if($needle=='' || $haystack == '') return false;			
		return (strpos($haystack, $needle) !== FALSE);
	}
}

/**
* Returns true if the second string begins with the first string.
* @param string
* @param string
* @return boolean
*/
if(!function_exists('string_begins_with')){
	function string_begins_with($needle, $haystack){
		if(!validates_as('string', $needle)) return should_be('a string', $needle);
		if(!validates_as('string', $haystack)) return should_be('a string', $haystack);		
		
		if($needle=='' || $haystack == '') return false;
			
		return (strpos($haystack, $needle) === 0);
	}
}

/**
* Returns true if the second string ends with the first string.
* @param string
* @param string
* @return boolean
*/
if(!function_exists('string_ends_with')){
	function string_ends_with($needle, $haystack){
		if(!validates_as('string', $needle)) return should_be('a string', $needle);
		if(!validates_as('string', $haystack)) return should_be('a string', $haystack);		
		
		if($needle=='' || $haystack == '') return false;
		
		return (strrpos($haystack, $needle) === (strlen($haystack) - strlen($needle)));
	}
}

/**
* Returns true if the last character in the string is punctuation (and not whitespace).
* @param string
* @return boolean
*/
if(!function_exists('string_ends_with_punctuation')){
	function string_ends_with_punctuation($string){
		if(!validates_as('string', $string)) return should_be('a string', $string);
		if(empty($string)) return false;
		$last_char = substr($string, strlen($string)-1, 1);
		return !preg_match('/[a-zA-Z0-9\s]/', $last_char);
	}
}

/**
* Like {@link strip_from_end()}, except that it strips from the beginning.
*
* @param string
* @param string
* @return string
*/
if(!function_exists('strip_from_beginning')){
	function strip_from_beginning($needle, $haystack){
		if(!validates_as('string', $needle)) return should_be('a string', $needle);
		if(!validates_as('string', $haystack)) return should_be('a string', $haystack);		
		
		if(string_begins_with($needle, $haystack))
			return substr($haystack, strlen($needle), strlen($haystack));
		
		return $haystack;
	}
}


/**
* Strip a string from the end of a string.
* PHP's native {@link rtrim()} treats the characters you give it as 'characters to choose from' for stripping from the end.
* In contrast, this treats $needle as a full string that ought to be removed from the end if it's there.
* For example:
* <code>
* rtrim('hello world', 'hdle'); //returns 'hello wor'
* strip_from_end('hello_world', hdle'); //returns 'hello world' because the string 'hdle' was not at the end of the string
* </code>
*
* @param string $needle
* @param string $haystack
* @return string $haystack with $needle stripped from the end
*/
if(!function_exists('strip_from_end')){
	function strip_from_end($needle, $haystack){
		if(!validates_as('string', $needle)) return should_be('a string', $needle);
		if(!validates_as('string', $haystack)) return should_be('a string', $haystack);		
		
		if(string_ends_with($needle, $haystack)) return substr($haystack, 0, strrpos($haystack, $needle));
		
		return $haystack;
	}
}

/**
* Replace just the first instance of a string.
* PHP's native {@link str_replace()} will replace all instances of $needle.  Use this when you just want to replace the first instance of it.
*
* @param string $needle 
* @param string $replace_with
* @param string $haystack 
* @return string
*/
if(!function_exists('replace_first_with')){
	function replace_first_with($needle, $replace_with, $haystack){		
		foreach(array('needle', 'replace_with', 'haystack') as $var){
			if(!is_string($$var)) return should_be('a string', $$var);
		}
		
		if(!string_contains($needle, $haystack)) return $haystack;
			
		$needle_start = strpos($haystack, $needle);
		return substr($haystack, 0, $needle_start).$replace_with.substr($haystack, $needle_start + strlen($needle));	
	}
}


/**
* Replace just the last instance of a string.
* PHP's native {@link str_replace()} will replace all instances of $needle.  Use this when you just want to replace the last instance of it.
*
* @param string $needle 
* @param string $replace_with
* @param string $haystack 
* @return string
*/
if(!function_exists('replace_last_with')){
	function replace_last_with($needle, $replace_with, $haystack){		
		foreach(array('needle', 'replace_with', 'haystack') as $var){
			if(!is_string($$var)) return should_be('a string', $$var);
		}
		
		if(!string_contains($needle, $haystack)) return $haystack;
			
		$needle_start = strrpos($haystack, $needle);
		return substr($haystack, 0, $needle_start).$replace_with.substr($haystack, $needle_start + strlen($needle));	
	}
}

if(!function_exists('number_length')){
	function number_length($number){
		if(!validates_as('numeric', $number)) return should_be('number', $number);
		if($number === 0) return 1;
		if($number < 1) $number = abs($number);
		if($number - floor($number) == 0){
				return strlen(strip_from_end('.000000', sprintf("%f", $number)));        //seems to be the most reliable way to go about this -- check again if necessary
				#return floor( log($number, 10) ) + 1;
		}
	
		$integer_portion = floor( $number );
		$decimal_portion = $number - $integer_portion;
		$decimal_portion = strip_from_beginning('0.', rtrim(sprintf("%f", $decimal_portion), '0')); //MAY HAVE PRECISION PROBLEMS HERE.  grr, argh.
		
		return number_length($integer_portion) + number_length($decimal_portion);
	}

}

//known limitation -- this will treat hyphenated words as separate words
if(!function_exists('first_word')){
	function first_word($string){
		if(!validates_as('string', $string)) return should_be('string', $string);
		if(empty($string)) return '';
		return current(preg_split('/[^a-zA-Z0-9]/',$string, -1, PREG_SPLIT_NO_EMPTY));
	}
}

if(!function_exists('last_word')){
	function last_word($string){
		if(!validates_as('string', $string)) return should_be('string', $string);
		if(empty($string)) return '';
		return end(preg_split('/[^a-zA-Z0-9]/',$string, -1, PREG_SPLIT_NO_EMPTY));
	}
}


/** If we're outside of a normal Codeigniter instance, bring in the parent CI helper in case there are any dependencies */
if(!defined('CI_VERSION') && defined('CODEIGNITER_SYSTEM_DIRECTORY')) require_once CODEIGNITER_SYSTEM_DIRECTORY.'helpers/string_helper.php';

/* End of file ICARUS_string_helper.php */